clear all;
close all;

%File details
    delimiterIn = ' ';
    headerLinesIn = 0;

    if(exist('PathName','var')==0); PathName = ''; end

%Open the datafile
    FilterSpec = '.dat';
    DialogTitle = 'Select file with H/R data.';
    [posH_Datafile,PathName] = uigetfile(FilterSpec,DialogTitle,PathName);
    imp_Data = importdata([PathName,posH_Datafile],delimiterIn,headerLinesIn);
   
%Checks to see if datafiles are structures
    if(isstruct(imp_Data)); Data=imp_Data.data;
    else Data = imp_Data; end  

n = size(Data,1);
j = 1;
for i = 1:n
    if Data(i,1) >= 0;
       Data1(j,1) = Data(i,1);
       Data1(j,2) = Data(i,2);
       j = j + 1;
    else
    end
end
    
% Average data with the same x value.
    [C,ia,idx] = unique(Data1(:,1),'stable');
    val = accumarray(idx,Data1(:,2),[],@mean); 
    Data_unique = [C val];
 
% Use an interpolant fit (spline) and calculate results every 10mK.
    H = Data_unique(:,1);
    R = Data_unique(:,2);
    HH = 0.1:0.01:15.9;
    HH = reshape(HH,[size(HH,2),1]);
    RR = spline(H,R,HH);

% Smooth data.
% Change value/smoothing type, however be will smear out features.
    yy = smooth(HH,RR,0.01,'moving');

% Plot R/T curve, and check for errors in the average/smoothing process.
    figure;
    hold on;
    box on;
    plot(Data1(:,1),Data1(:,2),HH,yy);
    set(gca,'fontsize',15,'fontname','times');
    set(gcf,'color','w');
    xlabel('H (\mu_{0}T)','fontsize',20,'fontname','times');
    ylabel('Resistance (\Omega)','fontsize',20,'fontname','times');
    
% Calculate derivative.
    dRdH = gradient(yy,HH);

% Fit sc transition  
    Data_sc(:,1) = HH;
    Data_sc(:,2) = dRdH;
    range = 8;

    i = 1;
    while(Data_sc(i,1)<range) 
        i = i + 1; 
    end

    f = fit(Data_sc(1:i,1),Data_sc(1:i,2),'gauss1')
    coeffvals = coeffvalues(f);
    b1 = coeffvals(2);
    c1 = coeffvals(3);

    figure;
    plot(f,Data_sc(:,1),Data_sc(:,2),'xk');
    set(gca,'fontsize',15,'fontname','times');
    set(gcf,'color','w');
    xlabel('\it T (K)','fontsize',20,'fontname','times');
    ylabel('\it dR/dT (arb. units)','fontsize',20,'fontname','times');
    title('FeSeLF8');
    
    %Linear fit through the sc transition
    n = size(HH,1);
    j = 1;
    for i = 1:n
        if HH(i,1) <= (b1+c1/2) && HH(i,1) >= (b1-c1/2)
            Hcmid(j,1) = HH(i,1);
            Hcmid(j,2) = yy(i,1);
            j = j + 1;
        end
    end
    Hcmid_fit = polyfit(Hcmid(:,1),Hcmid(:,2),1);
    Hcmid_x = 0.1:0.01:range;
    Hcmid_y = polyval(Hcmid_fit,Hcmid_x);
    
%Linear fit through sc region
    n = size(HH,1);
    nr = round((n./10));
    j = 1;
    for i = 1:nr
        Hclow(j,1) = HH(i,1);
        Hclow(j,2) = yy(i,1);
        j = j + 1;
    end
    Hclow_fit = polyfit(Hclow(:,1),Hclow(:,2),1);
    Hclow_x = 0.1:0.01:range;
    Hclow_y = polyval(Hclow_fit,Hcmid_x);
    
%Linear fit through normal region
    n = size(HH,1);
    nr = round((n./10));
    j = 1;
    for i = (n-nr):n
        Hchigh(j,1) = HH(i,1);
        Hchigh(j,2) = yy(i,1);
        j = j + 1;
    end
    Hchigh_fit = polyfit(Hchigh(:,1),Hchigh(:,2),1);
    Hchigh_x = 0.1:0.01:range;
    Hchigh_y = polyval(Hchigh_fit,Hchigh_x);
       
%Calculate intercepts
    b0 = InterX([Hclow_x;Hclow_y],[Hcmid_x;Hcmid_y]); 
    b0 = b0(1);
    b2 = InterX([Hcmid_x;Hcmid_y],[Hchigh_x;Hchigh_y]);
    b2 = b2(1);
   
    
%Plot to check linear fits    
    xmin = min(HH); xmax = max(HH);
    ymin = min(yy)-0.5; ymax = max(yy)+0.5;
    figure;
    hold on;
    plot(HH,yy);
    plot(Hcmid_x,Hcmid_y);
    plot(Hclow_x,Hclow_y);
    plot(Hchigh_x,Hchigh_y);
    xlim([xmin xmax]);
    ylim([ymin ymax]);
    set(gca,'fontsize',15,'fontname','times');
    set(gcf,'color','w');
    xlabel('\it T (K)','fontsize',20,'fontname','times');
    ylabel('\it R (\Omega)','fontsize',20,'fontname','times');
    title('FeSeLF8');
    box on;
    
    disp('Onset temperature (K)'); b2
    disp('Midpoint temperature (K)'); b1
    disp('Offset temperature (K)'); b0
          
    
    
    


